/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import net.adventurez.init.EntityInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.mixin.accessor.EntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnderWhaleEntity
extends FlyingMob
implements ItemSteerable {
    private static final EntityDataAccessor<Boolean> ALWAYS_SADDLED = SynchedEntityData.m_135353_(EnderWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.m_135353_(EnderWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemBasedSteering saddledComponent;

    public EnderWhaleEntity(EntityType<? extends FlyingMob> entityType, Level world) {
        super(entityType, world);
        this.saddledComponent = new ItemBasedSteering(this.f_19804_, BOOST_TIME, ALWAYS_SADDLED);
        this.f_21342_ = new EnderWhaleMovementControl(this);
        this.m_274367_(1.0f);
        this.f_21364_ = 5;
    }

    public static AttributeSupplier.Builder createEnderWhaleAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.022).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22278_, 2.5);
    }

    public static boolean canSpawn(EntityType<EnderWhaleEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        BlockState blockState = world.m_8055_(pos);
        return random.m_188503_(6) == 0 && pos.m_123342_() > 40 && pos.m_123342_() - world.m_5452_(Heightmap.Types.WORLD_SURFACE, pos).m_123342_() > 20 && blockState.m_60795_() && world.m_6443_(EnderDragon.class, new AABB(pos).m_82400_(80.0), EntitySelector.f_20408_).isEmpty() && NaturalSpawner.m_47056_((BlockGetter)world, (BlockPos)pos, (BlockState)blockState, (FluidState)blockState.m_60819_(), EntityInit.ENDER_WHALE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new FlyRandomlyGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal(this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemInit.CHORUS_FRUIT_ON_A_STICK})));
        this.f_21345_.m_25352_(7, (Goal)new LookWhereToFlyGoal(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ALWAYS_SADDLED, (Object)true);
        this.f_19804_.m_135372_(BOOST_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.saddledComponent.m_20847_(nbt);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.saddledComponent.m_20852_(nbt);
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < 2;
    }

    @Nullable
    public LivingEntity m_6688_() {
        return !this.m_20197_().isEmpty() && this.m_20197_().get(0) instanceof Player && ((Player)this.m_20197_().get(0)).m_21205_().m_150930_(ItemInit.CHORUS_FRUIT_ON_A_STICK) ? (LivingEntity)this.m_20197_().get(0) : null;
    }

    protected float m_245547_(Player controllingPlayer) {
        return (float)this.m_21133_(Attributes.f_22279_) * this.saddledComponent.m_274439_();
    }

    protected SoundEvent m_7515_() {
        return SoundInit.WHALE_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.WHALE_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.WHALE_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected float m_6121_() {
        return 1.1f;
    }

    public int m_8100_() {
        return 500;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!player.m_36341_()) {
            if ((player.m_21120_(hand).m_150930_(Items.f_42730_) || player.m_21120_(hand).m_150930_(Items.f_42731_)) && this.m_21233_() - this.m_21223_() > 0.1f) {
                if (!this.m_9236_().m_5776_() && !player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                    this.m_5634_(4.0f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (!this.m_20160_()) {
                if (!this.m_9236_().m_5776_()) {
                    player.m_20329_((Entity)this);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (((EntityAccessor)((Object)this)).getPassengerList().size() < 2) {
                if (!this.m_9236_().m_5776_()) {
                    player.m_7998_((Entity)this, true);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(passenger);
        }
        int[][] is = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockPos = this.m_20183_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Pose entityPose : passenger.m_7431_()) {
            AABB box = passenger.m_21270_(entityPose);
            int[][] var9 = is;
            int var10 = is.length;
            for (int var11 = 0; var11 < var10; ++var11) {
                int[] js = var9[var11];
                mutable.m_122178_(blockPos.m_123341_() + js[0], blockPos.m_123342_(), blockPos.m_123343_() + js[1]);
                double d = this.m_9236_().m_45573_((BlockPos)mutable);
                if (!DismountHelper.m_38439_((double)d)) continue;
                Vec3 vec3d = Vec3.m_82514_((Vec3i)mutable, (double)d);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)passenger, (AABB)box.m_82383_(vec3d))) continue;
                passenger.m_20124_(entityPose);
                return vec3d;
            }
        }
        return super.m_7688_(passenger);
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.m_6688_() != null) {
            if (this.m_6109_()) {
                this.m_19920_(this.m_6113_(), movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
            this.m_267651_(false);
        } else {
            super.m_7023_(movementInput);
        }
    }

    protected Vec3 m_274312_(Player controllingPlayer, Vec3 movementInput) {
        return new Vec3(0.0, (double)(controllingPlayer.m_146909_() / 180.0f * -1.0f), 1.0);
    }

    protected void m_274498_(Player controllingPlayer, Vec3 movementInput) {
        super.m_274498_(controllingPlayer, movementInput);
        this.m_19915_(controllingPlayer.m_146908_(), controllingPlayer.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        this.saddledComponent.m_274606_();
    }

    public boolean m_6746_() {
        return this.saddledComponent.m_217032_(this.m_217043_());
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction positionUpdater) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        float offSet = 12.0f;
        if (passenger.equals((Object)this.m_146895_())) {
            offSet = 1.0f;
        }
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * offSet;
        float g = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * offSet;
        positionUpdater.m_20372_(passenger, this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.83f) + passenger.m_6049_() + 0.0, this.m_20189_() - (double)(0.1f * g));
    }

    public boolean m_6094_() {
        return false;
    }

    private static class EnderWhaleMovementControl
    extends MoveControl {
        private final EnderWhaleEntity enderWhaleEntity;
        private int collisionCheckCooldown;
        private int waitCooldown;

        public EnderWhaleMovementControl(EnderWhaleEntity enderWhaleEntity) {
            super((Mob)enderWhaleEntity);
            this.enderWhaleEntity = enderWhaleEntity;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.collisionCheckCooldown-- <= 0) {
                this.collisionCheckCooldown += 3;
                Vec3 vec3d = new Vec3(this.f_24975_ - this.enderWhaleEntity.m_20185_(), this.f_24976_ - this.enderWhaleEntity.m_20186_(), this.f_24977_ - this.enderWhaleEntity.m_20189_());
                double d = Math.sqrt(vec3d.f_82479_ * vec3d.f_82479_ + vec3d.f_82480_ * vec3d.f_82480_ + vec3d.f_82481_ * vec3d.f_82481_);
                vec3d = new Vec3(vec3d.f_82479_ / d, vec3d.f_82480_ / d, vec3d.f_82481_ / d);
                if (!this.willCollide() && d > 1.0 || this.waitCooldown++ < 0 && d > 1.0) {
                    this.enderWhaleEntity.m_20256_(vec3d.m_82490_(0.12));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    if (this.waitCooldown++ >= 200) {
                        this.waitCooldown = -40;
                    }
                }
            }
        }

        private boolean willCollide() {
            AABB box = this.enderWhaleEntity.m_20191_();
            box = box.m_82400_(0.2);
            return !this.enderWhaleEntity.m_9236_().m_45756_((Entity)this.enderWhaleEntity, box);
        }
    }

    private static class FlyRandomlyGoal
    extends Goal {
        private final EnderWhaleEntity enderWhaleEntity;

        public FlyRandomlyGoal(EnderWhaleEntity enderWhaleEntity) {
            this.enderWhaleEntity = enderWhaleEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            MoveControl moveControl = this.enderWhaleEntity.m_21566_();
            return !moveControl.m_24995_();
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.enderWhaleEntity.m_217043_();
            double randomX = 48.0 + (random.m_188500_() * 2.0 - 1.0) * 128.0;
            double randomZ = 48.0 + (random.m_188500_() * 2.0 - 1.0) * 128.0;
            double d = this.enderWhaleEntity.m_20185_() + randomX;
            double e = this.enderWhaleEntity.m_20186_() + (random.m_188500_() * 2.0 - 1.0) * 16.0;
            double f = this.enderWhaleEntity.m_20189_() + randomZ;
            if (this.enderWhaleEntity.m_20186_() < 40.0) {
                e = this.enderWhaleEntity.m_20186_() + 16.0 * random.m_188500_();
            } else if (this.enderWhaleEntity.m_20186_() > 100.0) {
                e = this.enderWhaleEntity.m_20186_() - 16.0 * random.m_188500_();
            }
            this.enderWhaleEntity.m_21566_().m_6849_(d, e, f, 1.0);
        }
    }

    private static class TemptGoal
    extends Goal {
        private static final TargetingConditions TEMPTING_ENTITY_PREDICATE = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_();
        private final TargetingConditions predicate;
        private final EnderWhaleEntity enderWhaleEntity;
        private final double speed;
        private double lastPlayerX;
        private double lastPlayerY;
        private double lastPlayerZ;
        private double lastPlayerPitch;
        private double lastPlayerYaw;
        protected Player closestPlayer;
        private int cooldown;
        private final Ingredient food;

        public TemptGoal(EnderWhaleEntity entity, double speed, Ingredient food) {
            this.enderWhaleEntity = entity;
            this.speed = speed;
            this.food = food;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.predicate = TEMPTING_ENTITY_PREDICATE.m_148354_().m_26888_(this::isTemptedBy);
        }

        public boolean m_8036_() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.closestPlayer = this.enderWhaleEntity.m_9236_().m_45946_(this.predicate, (LivingEntity)this.enderWhaleEntity);
            return this.closestPlayer != null;
        }

        private boolean isTemptedBy(LivingEntity entity) {
            return this.food.test(entity.m_21205_()) || this.food.test(entity.m_21206_());
        }

        public boolean m_8045_() {
            if (this.enderWhaleEntity.m_20280_((Entity)this.closestPlayer) < 36.0) {
                if (this.closestPlayer.m_20275_(this.lastPlayerX, this.lastPlayerY, this.lastPlayerZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.closestPlayer.m_146909_() - this.lastPlayerPitch) > 5.0 || Math.abs((double)this.closestPlayer.m_146908_() - this.lastPlayerYaw) > 5.0) {
                    return false;
                }
            } else {
                this.lastPlayerX = this.closestPlayer.m_20185_();
                this.lastPlayerY = this.closestPlayer.m_20186_();
                this.lastPlayerZ = this.closestPlayer.m_20189_();
            }
            this.lastPlayerPitch = this.closestPlayer.m_146909_();
            this.lastPlayerYaw = this.closestPlayer.m_146908_();
            return this.m_8036_();
        }

        public void m_8056_() {
            this.lastPlayerX = this.closestPlayer.m_20185_();
            this.lastPlayerY = this.closestPlayer.m_20186_();
            this.lastPlayerZ = this.closestPlayer.m_20189_();
        }

        public void m_8041_() {
            this.closestPlayer = null;
            this.enderWhaleEntity.m_21573_().m_26573_();
            this.cooldown = 100;
        }

        public void m_8037_() {
            this.enderWhaleEntity.m_21563_().m_24960_((Entity)this.closestPlayer, (float)(this.enderWhaleEntity.m_8085_() + 20), (float)this.enderWhaleEntity.m_8132_());
            if (this.enderWhaleEntity.m_20280_((Entity)this.closestPlayer) < 9.25) {
                this.enderWhaleEntity.m_21573_().m_26573_();
            } else {
                this.enderWhaleEntity.m_21573_().m_5624_((Entity)this.closestPlayer, this.speed);
            }
        }
    }

    private static class LookWhereToFlyGoal
    extends Goal {
        private final EnderWhaleEntity enderWhaleEntity;

        public LookWhereToFlyGoal(EnderWhaleEntity enderWhaleEntity) {
            this.enderWhaleEntity = enderWhaleEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            Vec3 vec3d = this.enderWhaleEntity.m_20184_();
            this.enderWhaleEntity.m_146922_(-((float)Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_)) * 57.295776f);
            this.enderWhaleEntity.f_20883_ = this.enderWhaleEntity.m_146908_();
        }
    }
}

